//
// Magic Wand Control for Openlayers 2.13
//
// The MIT License (MIT)
//
// Copyright (c) 2014, Ryasnoy Paul (ryasnoypaul@gmail.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

OpenLayers.Tile.Mask=OpenLayers.Class(OpenLayers.Tile,{cvsDiv:null,canvasContext:null,image:null,border:null,hatchInterval:null,hatchOffset:0,initialize:function(d,a,b,c){OpenLayers.Tile.prototype.initialize.call(this,d,a,null,null,b,c);this.createCanvas();a&&this.setPosition(a);b&&this.setCanvasSize(b);var e=this;if(this.layer.hatchTimeout&&this.layer.hatchTimeout>0)this.hatchInterval=setInterval(function(){e.hatchTick()},this.layer.hatchTimeout)},destroy:function(){this.hatchInterval&&clearInterval(this.hatchInterval);this.cvsDiv&&this.clear();OpenLayers.Tile.prototype.destroy.call(this)},setBounds:function(){},shouldDraw:function(){return true},draw:function(){return this.drawBorder()},hatchTick:function(){this.hatchOffset=(this.hatchOffset+1)%(this.layer.hatchLength*2);return this.drawBorder(true)},setPosition:function(a){var b=this.cvsDiv.style;b.left=a.x+"px";b.top=a.y+"px";this.position=a},setCanvasSize:function(a){this.canvasContext.canvas.width=a.w;this.canvasContext.canvas.height=a.h;this.size=a},clear:function(){OpenLayers.Tile.prototype.clear.call(this);if(this.cvsDiv){this.cvsDiv.parentNode===this.layer.div&&this.layer.div.removeChild(this.cvsDiv);this.cvsDiv=null}this.canvasContext=null},createCanvas:function(){this.cvsDiv=document.createElement("canvas");this.layer.div.appendChild(this.cvsDiv);this.canvasContext=this.cvsDiv.getContext("2d");this.className="olTileMask";var a=this.cvsDiv.style;if(this.layer.opacity<1)a.filter="alpha(opacity="+this.layer.opacity*100+")";a.position="absolute"},clearImage:function(){this.image=null;this.border=null;this.canvasContext&&this.canvasContext.clearRect(0,0,this.size.w,this.size.h)},setImage:function(a){this.image=a;this.drawBorder()},drawBorder:function(P){if(!this.image)return false;var e,b,a,k,m,z=this.size.w,L=this.size.h,n=this.size.w-1,o=this.size.h-1,d=this.size.w+2,K=this.size.h+2;if(!P){var i,j,p,r,q,s,H,I,h,F,x,G,R=this.image.data,y=this.image.width,t=this.image.bounds,J=this.image.globalOffset,E=new Uint8Array(d*K),l=Math.round(this.layer.map.minPx.x),v=Math.round(this.layer.map.minPx.y),Q=Math.round(this.layer.map.maxPx.x),D=Q-l,u,C=[{x:-l,y:-v},{x:-(l-D),y:-v},{x:-(l+D),y:-v}],O=C.length;for(b=0;b<O;b++){u=C[b];i=J.x-u.x;j=J.y-u.y;p=i+t.minX;r=j+t.minY;q=i+t.maxX;s=j+t.maxY;if(!(q<0||p>n||s<0||r>o)){h=p>-1?p:-1;x=r>-1?r:-1;F=q<n+1?q:n+1;G=s<o+1?s:o+1}else continue;m=F-h+1;e=(x+1)*d+(h+1);H=(x-j)*y+(h-i);I=(G-j)*y+(h-i)+1;for(a=H;a<I;a+=y){for(k=0;k<m;k++)if(R[a+k]===1)E[e+k]=1;e+=d}}this.border=MagicWand.getBorderIndices({data:E,width:d,height:K})}this.canvasContext.clearRect(0,0,z,L);var w=this.border;if(!w)return false;var c,f,B=this.canvasContext.createImageData(z,L),g=B.data,A=this.layer.hatchLength,M=A*2,N=this.hatchOffset;m=w.length;for(b=0;b<m;b++){e=w[b],c=e%d;f=(e-c)/d;c-=1;f-=1;if(c<0||c>n||f<0||f>o)continue;a=(f*z+c)*4;if((c+f+N)%M<A)g[a+3]=255;else{g[a]=255;g[a+1]=255;g[a+2]=255;g[a+3]=255}}this.canvasContext.putImageData(B,0,0);return true},drawBorderOld:function(J){if(!this.image)return false;var i,c,j,d,k,e,E,g,w,b,y;if(!J){var C={x:Math.round(-this.layer.map.minPx.x),y:Math.round(-this.layer.map.minPx.y)},K=this.image.data,x=this.image.width,v=this.image.bounds,G=this.image.globalOffset,t=G.x-C.x,u=G.y-C.y,o=t+v.minX,q=u+v.minY,p=t+v.maxX,r=u+v.maxY,m=this.size.w-1,n=this.size.h-1;if(!(p<0||o>m||r<0||q>n)){c=o>0?o:0,d=q>0?q:0,j=p<m?p:m,k=r<n?r:n,e=o>-1?o:-1;g=q>-1?q:-1;E=p<m+1?p:m+1;w=r<n+1?r:n+1}else return false;b=E-e+1;y=w-g+1;for(var D=new Uint8Array(b*y),s=0,M=(g-u)*x+(e-t),N=(w-u)*x+(e-t)+1,a=M;a<N;a+=x){D.set(K.subarray(a,a+b),s);s+=b}i=MagicWand.getBorderIndices({data:D,width:b,height:y});this.border={data:i,offsetX:e,offsetY:g,minX:c,minY:d,maxX:j,maxY:k,width:b}}else{i=this.border.data;e=this.border.offsetX;g=this.border.offsetY;c=this.border.minX;d=this.border.minY;j=this.border.maxX;k=this.border.maxY;b=this.border.width}for(var F=j-c+1,O=k-d+1,B=this.canvasContext.createImageData(F,O),l=B.data,L=i.length,f,h,A=this.layer.hatchLength,H=A*2,I=this.hatchOffset,z=0;z<L;z++){s=i[z],f=s%b;h=(s-f)/b;f+=e;h+=g;if(f<c||f>j||h<d||h>k)continue;a=((h-d)*F+f-c)*4;if((f+h+I)%H<A)l[a+3]=255;else{l[a]=255;l[a+1]=255;l[a+2]=255;l[a+3]=255}}this.canvasContext.clearRect(0,0,this.size.w,this.size.h);this.canvasContext.putImageData(B,c,d);return true},getContours:function(h){if(!this.image)return null;var c,d,e,j,g,b,f=this.image,k=f.globalOffset.x+Math.round(this.layer.map.minPx.x),l=f.globalOffset.y+Math.round(this.layer.map.minPx.y),a=MagicWand.traceContours(f),i=[];if(this.layer.simplifyTolerant>0)a=MagicWand.simplifyContours(a,this.layer.simplifyTolerant,this.layer.simplifyCount);j=a.length;for(c=0;c<j;c++){b=a[c];e=b.points;g=e.length;b.initialCount=b.initialCount||g;if(h&&h(b)===false)continue;for(d=0;d<g;d++){e[d].x+=k;e[d].y+=l}i.push(a[c])}return i},CLASS_NAME:"OpenLayers.Tile.Mask"});OpenLayers.Layer.Mask=OpenLayers.Class(OpenLayers.Layer,{alwaysInRange:true,tile:null,hatchLength:4,hatchTimeout:300,simplifyTolerant:1,simplifyCount:30,resolution:null,destroy:function(){if(this.tile){this.tile.destroy();this.tile=null}OpenLayers.Layer.prototype.destroy.call(this)},moveTo:function(c,a,b){OpenLayers.Layer.prototype.moveTo.call(this,c,a,b);if(Math.abs(this.map.resolution-this.resolution)>1e-6||!this.tile){this.resolution=this.map.resolution;this.tile&&this.tile.destroy();this.tile=new OpenLayers.Tile.Mask(this,this.getTilePosition(),this.getTileSize());this.events.triggerEvent("createtile",{tile:this.tile})}else{this.tile.setCanvasSize(this.getTileSize());this.tile.setPosition(this.getTilePosition())}this.tile.draw()},moveByPx:function(){this.tile.setPosition(this.getTilePosition());this.tile.draw()},getTileSize:function(){return this.map.getCurrentSize().clone()},getTilePosition:function(){return new OpenLayers.Pixel(-this.map.layerContainerOriginPx.x,-this.map.layerContainerOriginPx.y)},onResize:function(){this.tile.setCanvasSize(this.getTileSize());this.tile.draw()},CLASS_NAME:"OpenLayers.Layer.Mask"});OpenLayers.Layer.Snapshot=OpenLayers.Class({layer:null,bytes:4,size:null,image:null,eventListeners:null,events:null,initialize:function(b,a){OpenLayers.Util.extend(this,a);this.events=new OpenLayers.Events(this);if(this.eventListeners instanceof Object)this.events.on(this.eventListeners);this.layer=b},getPixelColor:function(c,d){var a=(d*this.size.w+c)*this.bytes,b=[this.image[a],this.image[a+1],this.image[a+2],this.image[a+3]];return b},toImageUrl:function(c){if(!this.image||!this.size)return null;c=c||"image/png";var e=document.createElement("canvas"),a=e.getContext("2d");a.canvas.width=this.size.w;a.canvas.height=this.size.h;for(var d=a.createImageData(this.size.w,this.size.h),b=0;b<this.image.length;b++)d.data[b]=this.image[b];a.putImageData(d,0,0);return e.toDataURL(c)},isReady:function(){return false},destroy:function(){this.image=null;this.events.triggerEvent("destroy",null);this.events.destroy();this.events=null},CLASS_NAME:"OpenLayers.Layer.Snapshot"});OpenLayers.Layer.Snapshot.Grid=OpenLayers.Class(OpenLayers.Layer.Snapshot,{cache:null,cacheCount:0,tilesCount:0,initialize:function(b,a){OpenLayers.Layer.Snapshot.prototype.initialize.call(this,b,a);this.scan()},scan:function(){this.cacheCount=0;this.cache={};if(this.layer.map&&this.layer.grid.length>0){this.events.triggerEvent("scanstart",{snapshot:this});this.size=this.layer.map.getCurrentSize();this.image=new Uint8Array(this.size.w*this.size.h*this.bytes);this.tilesCount=this.layer.grid.length*this.layer.grid[0].length;this.connectToLayer();for(var b=0,d=this.layer.grid.length;b<d;b++)for(var c=0,e=this.layer.grid[b].length;c<e;c++){var a=this.layer.grid[b][c];if(a.shouldDraw())!a.isLoading&&a.imgDiv&&this.addToCache(a);else this.tilesCount--}this.isReady()&&this.onLoadEnd();return true}return false},connectToLayer:function(){this.layer.events.register("tileloaded",this,this.onTileLoaded)},disconnectFromLayer:function(){this.layer.events.unregister("tileloaded",this,this.onTileLoaded)},onTileLoaded:function(a){this.addToCache(a.tile);this.isReady()&&this.onLoadEnd()},onLoadEnd:function(){this.disconnectFromLayer();this.events.triggerEvent("scanfinish",{snapshot:this})},addToCache:function(a){if(!this.cache[a.id]){this.cache[a.id]=a;this.cacheCount++;try{this.addToImage(a)}catch(b){}}},addToImage:function(h){var b=this.layer.tileSize.w,j=this.layer.tileSize.h,o=h.getCanvasContext().getImageData(0,0,b,j),n=o.data,p=this.image,a=this.bytes,f=h.position.x+this.layer.map.layerContainerOriginPx.x,g=h.position.y+this.layer.map.layerContainerOriginPx.y,e=this.size.w,c=Math.max(0,f),i=Math.max(0,g),k=Math.min(e,f+b)-1,l=Math.min(this.size.h,g+j)-1;if(c>k||i>l)return;var m=(i*e+c)*a,q=(k-c+1)*a,t=b*a,r=((i-g)*b+c-f)*a,s=((l-g)*b+c-f+1)*a;e*=a;for(var d=r;d<s;d+=t){p.set(n.subarray(d,d+q),m);m+=e}},isReady:function(){return this.tilesCount==this.cacheCount},destroy:function(){this.cache=null;this.disconnectFromLayer();OpenLayers.Layer.Snapshot.prototype.destroy.call(this)},CLASS_NAME:"OpenLayers.Layer.Snapshot.Grid"});OpenLayers.Layer.Snapshot.Google=OpenLayers.Class(OpenLayers.Layer.Snapshot,{cache:null,tilesAll:0,tilesLoaded:0,ready:false,googleListeners:null,initialize:function(b,a){OpenLayers.Layer.Snapshot.prototype.initialize.call(this,b,a);this.cache=[];this.scan()},scan:function(){if(this.layer.map){this.size=this.layer.map.getCurrentSize();this.connectToGoogle();this.onTilesLoad();return true}return false},connectToGoogle:function(){var a=this;this.disconnectFromGoogle();this.googleListeners=[];this.googleListeners.push(google.maps.event.addListenerOnce(this.layer.mapObject,"tilesloaded",function(){a.onGoogleTilesLoaded()}))},disconnectFromGoogle:function(){if(!this.googleListeners)return false;for(var a=0;a<this.googleListeners.length;a++)google.maps.event.removeListener(this.googleListeners[a]);this.googleListeners.length=0;return true},onGoogleIdle:function(){this.onTilesLoad()},onGoogleTilesLoaded:function(){var a=this;this.googleListeners.push(google.maps.event.addListenerOnce(this.layer.mapObject,"idle",function(){a.onGoogleIdle()}));this.layer.mapObject.panBy(0,1);this.layer.mapObject.panBy(0,-1)},getGoogleImages:function(b){if(!b.getMapContainer)return[];for(var f=Array.prototype.slice.call(b.getMapContainer().getElementsByTagName("img")),g=f.length,e=[],d=b.tileSize,a,c=0;c<g;c++){a=f[c];a.src.search("google")!=-1&&a.width==d.w&&a.height==d.h&&e.push(a)}return e},onTilesLoad:function(){this.ready=false;this.tilesAll=0;this.tilesLoaded=0;this.image=new Uint8Array(this.size.w*this.size.h*this.bytes);this.disconnectFromImages();this.events.triggerEvent("scanstart",{snapshot:this});var b=this.getGoogleImages(this.layer),c,d,m,j,e,f,h=this.layer.map.getControlsByClass("OpenLayers.Control.OverviewMap");for(c=0,m=h.length;c<m;c++){e=this.getGoogleImages(h[c].ovmap.baseLayer);for(d=0,j=e.length;d<j;d++){f=b.indexOf(e[d]);f!=-1&&b.splice(f,1)}}this.tilesAll=b.length;for(var l=this.layer.map.viewPortDiv.getBoundingClientRect(),g=0;g<this.tilesAll;g++){var k=b[g],i=k.getBoundingClientRect(),a=new Image;this.cache.push(a);a.setAttribute("crossorigin","anonymous");OpenLayers.Event.observe(a,"load",OpenLayers.Function.bind(this.onImageLoad,this,a,i.left-l.left,i.top-l.top));a.src=k.src}return true},onImageLoad:function(a,b,c){this.addToImage(a,b,c);++this.tilesLoaded==this.tilesAll&&this.onLoadEnd()},disconnectFromImages:function(){for(var a=0;a<this.cache.length;a++)OpenLayers.Event.stopObservingElement(this.cache[a]);this.cache.length=0},onLoadEnd:function(){this.disconnectFromImages();this.ready=true;this.events.triggerEvent("scanfinish",{snapshot:this})},addToImage:function(r,f,g){var a=this.layer.tileSize.w,h=this.layer.tileSize.h,q=this.image,b=this.bytes,e=this.size.w,c=Math.max(0,f),j=Math.max(0,g),l=Math.min(e,f+a)-1,m=Math.min(this.size.h,g+h)-1;if(c>l||j>m)return;var i=document.createElement("canvas");i.width=a;i.height=h;var k=i.getContext("2d");k.drawImage(r,0,0);var p=k.getImageData(0,0,a,h),o=p.data,n=(j*e+c)*b,s=(l-c+1)*b,v=a*b,t=((j-g)*a+c-f)*b,u=((m-g)*a+c-f+1)*b;e*=b;for(var d=t;d<u;d+=v){q.set(o.subarray(d,d+s),n);n+=e}},isReady:function(){return this.ready},destroy:function(){this.disconnectFromImages();this.disconnectFromGoogle();this.cache=null;OpenLayers.Layer.Snapshot.prototype.destroy.call(this)},CLASS_NAME:"OpenLayers.Layer.Snapshot.Google"});OpenLayers.Handler.Mouse=OpenLayers.Class(OpenLayers.Handler,{mousemove:function(a){this.callback("move",[a])},mousedown:function(a){this.callback("down",[a])},mouseup:function(a){this.callback("up",[a])}});OpenLayers.Control.MagicWand=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,layer:null,maskLayer:null,waitClass:null,drawClass:null,addClass:null,colorThreshold:15,blurRadius:5,resetLayerOnDeactivate:false,snapshot:null,history:null,isMapConnect:false,allowDraw:false,addMode:false,currentThreshold:0,downPoint:null,oldImage:null,initialize:function(a){OpenLayers.Control.prototype.initialize.call(this,a);this.init()},init:function(){this.currentThreshold=this.colorThreshold;this.layer&&this.setLayer(this.layer);this.history=new OpenLayers.Control.MagicWand.MaskHistory;this.handlers={keyboard:new OpenLayers.Handler.Keyboard(this,{keydown:this.keydown,keyup:this.keyup}),mouse:new OpenLayers.Handler.Mouse(this,{move:this.move,down:this.down,up:this.up})}},destroy:function(){this.onDeactivate();this.history&&this.history.destroy();OpenLayers.Control.prototype.destroy.call(this)},setColorThreshold:function(a){this.currentThreshold=this.colorThreshold=a},setBlurRadius:function(a){this.blurRadius=a},getLayer:function(){return this.layer||this.map.baseLayer},setLayer:function(a){this.layer=a.isBaseLayer?null:a;if(this.active){this.clearImage();this.createSnapshot()}},clearImage:function(){this.maskLayer&&this.maskLayer.tile&&this.maskLayer.tile.clearImage()},connectToMaskLayer:function(){this.maskLayer.events.on({createtile:this.onCreateMaskTile,scope:this})},disconnectFromMaskLayer:function(){this.maskLayer.events.un({createtile:this.onCreateMaskTile,scope:this})},onCreateMaskTile:function(){this.history&&this.history.clear()},setMap:function(a){OpenLayers.Control.prototype.setMap.call(this,a);this.handlers.mouse&&this.handlers.mouse.setMap(a);this.handlers.keyboard&&this.handlers.keyboard.setMap(a);this.connectToMap()},connectToMap:function(){if(this.isMapConnect||!this.active)return false;this.map.events.on({moveend:this.onMapMoveEnd,updatesize:this.onMapUpdateSize,changebaselayer:this.onChangeBaseLayer,scope:this});this.onMapMoveEnd();this.isMapConnect=true;return true},disconnectFromMap:function(){if(!this.isMapConnect||this.active)return false;this.map.events.un({moveend:this.onMapMoveEnd,updatesize:this.onMapUpdateSize,changebaselayer:this.onChangeBaseLayer,scope:this});this.isMapConnect=false;return true},onChangeBaseLayer:function(){this.createSnapshot()},onMapMoveEnd:function(){this.createSnapshot()},onMapUpdateSize:function(){var a=this;setTimeout(function(){a.onMapResize()},50)},onMapResize:function(){this.createSnapshot();this.maskLayer.onResize()},activate:function(){OpenLayers.Control.prototype.activate.call(this);this.handlers.mouse&&this.handlers.mouse.activate();this.handlers.keyboard&&this.handlers.keyboard.activate();this.map.div.classList.add(this.drawClass);this.connectToMap();this.maskLayer&&this.connectToMaskLayer()},deactivate:function(){OpenLayers.Control.prototype.deactivate.call(this);this.onDeactivate()},onDeactivate:function(){this.handlers.mouse&&this.handlers.mouse.deactivate();this.handlers.keyboard&&this.handlers.keyboard.deactivate();if(this.resetLayerOnDeactivate)this.layer=null;this.allowDraw=false;this.downPoint=null;this.oldImage=null;this.addMode=false;this.disconnectFromMap();this.maskLayer&&this.disconnectFromMaskLayer();this.removeSnapshot();this.clearImage();this.history&&this.history.clear();this.map.div.classList.remove(this.drawClass);this.map.div.classList.remove(this.waitClass);this.map.div.classList.remove(this.addClass)},keydown:function(a){a.keyCode==17&&!this.map.div.classList.contains(this.addClass)&&this.map.div.classList.add(this.addClass)},keyup:function(e){e.keyCode==17&&this.map.div.classList.remove(this.addClass);if(e.keyCode==67){var g=this.maskLayer.tile.getContours(),c=this.maskLayer.tile.canvasContext;c.clearRect(0,0,this.maskLayer.tile.size.w,this.maskLayer.tile.size.h);var d,b,a;c.beginPath();for(d=0;d<g.length;d++){a=g[d].points;c.moveTo(a[0].x,a[0].y);for(b=1;b<a.length;b++)c.lineTo(a[b].x,a[b].y)}c.strokeStyle="red";c.stroke();c.fillStyle="aqua";for(d=0;d<g.length;d++){a=g[d].points;for(b=0;b<a.length;b++)c.fillRect(a[b].x,a[b].y,1,1)}}if(e.ctrlKey){var f=null;if(e.keyCode==89)f=this.history.redo();if(e.keyCode==90)f=this.history.undo();f&&this.maskLayer&&this.maskLayer.tile.setImage(f)}},move:function(m){if(this.allowDraw){var f=this.map.events.getMousePosition(m),j=Math.round(f.x),k=Math.round(f.y),d=this.downPoint.x,e=this.downPoint.y;if(j!=d||k!=e){var b=j-d,c=k-e,l=Math.sqrt(b*b+c*c),h=Math.abs(b),i=Math.abs(c),a=h>i?b/h:c/i;a=a<0?a/5:a/3;var g=Math.min(Math.max(this.colorThreshold+Math.round(a*l),1),255);if(g!=this.currentThreshold){this.currentThreshold=g;this.drawMask(d,e)}}}},down:function(a){if(a.button==2){if(!this.maskLayer||!this.snapshot||!this.snapshot.isReady())return;this.downPoint=this.map.events.getMousePosition(a);this.downPoint.x=Math.round(this.downPoint.x);this.downPoint.y=Math.round(this.downPoint.y);this.allowDraw=true;this.addMode=a.ctrlKey;this.drawMask(this.downPoint.x,this.downPoint.y)}else if(a.button==1){for(var c=this.maskLayer.tile.canvasContext.createImageData(this.maskLayer.tile.size.w,this.maskLayer.tile.size.h),b=0;b<this.snapshot.image.length;b++)c.data[b]=this.snapshot.image[b];this.maskLayer.tile.canvasContext.clearRect(0,0,this.maskLayer.tile.size.w,this.maskLayer.tile.size.h);this.maskLayer.tile.canvasContext.putImageData(c,0,0)}else{this.allowDraw=false;this.oldImage=null;this.addMode=false}},up:function(){this.allowDraw&&this.maskLayer&&this.history&&this.history.addMask(this.maskLayer.tile.image);this.currentThreshold=this.colorThreshold;this.allowDraw=false;this.oldImage=null;this.addMode=false},createSnapshot:function(){var a=this.getLayer();if(this.snapshot&&this.snapshot.layer==a){this.snapshot.scan();return}this.removeSnapshot();var b={eventListeners:{scanstart:function(){this.map.div.classList.add(this.waitClass)},scanfinish:function(){this.map.div.classList.remove(this.waitClass)},scope:this}};if(a instanceof OpenLayers.Layer.Grid)this.snapshot=new OpenLayers.Layer.Snapshot.Grid(a,b);else if(a instanceof OpenLayers.Layer.Google)this.snapshot=new OpenLayers.Layer.Snapshot.Google(a,b)},removeSnapshot:function(){if(this.snapshot){this.snapshot.destroy();this.snapshot=null}},concatMask:function(f,g){var w=g.data,x=f.data,s=g.width,t=f.width,o=g.globalOffset.x,q=g.globalOffset.y,p=f.globalOffset.x,r=f.globalOffset.y,a=g.bounds,b=f.bounds,l=Math.min(a.minX+o,b.minX+p),m=Math.min(a.minY+q,b.minY+r),u={minX:0,minY:0,maxX:Math.max(a.maxX+o,b.maxX+p)-l,maxY:Math.max(a.maxY+q,b.maxY+r)-m},e=u.maxX+1,v=u.maxY+1,d,h,c,j,k,i,n=new Uint8Array(e*v);i=a.maxX-a.minX+1;d=(q-m+a.minY)*e+(o-l+a.minX);j=a.minY*s+a.minX;k=a.maxY*s+a.minX+1;for(c=j;c<k;c+=s){n.set(w.subarray(c,c+i),d);d+=e}i=b.maxX-b.minX+1;d=(r-m+b.minY)*e+(p-l+b.minX);j=b.minY*t+b.minX;k=b.maxY*t+b.minX+1;for(c=j;c<k;c+=t){for(h=0;h<i;h++)if(x[c+h]===1)n[d+h]=1;d+=e}return{data:n,width:e,height:v,bounds:u,globalOffset:{x:l,y:m}}},drawMask:function(H,I){if(!(this.snapshot&&this.snapshot.image))return false;var d=this.snapshot.size,z=this.map.getCurrentSize();if(d.w!=z.w||d.h!=z.h){this.onMapResize();if(!this.snapshot.isReady())return false;d=this.snapshot.size}var q=this.maskLayer.tile,k={x:Math.round(-this.map.minPx.x),y:Math.round(-this.map.minPx.y)},a={data:this.snapshot.image,width:d.w,height:d.h,bytes:this.snapshot.bytes};if(this.addMode&&q.image){if(!this.oldImage){var c=q.image,j=c.bounds;this.oldImage={data:new Uint8Array(c.data),width:c.width,height:c.height,bounds:{minX:j.minX,maxX:j.maxX,minY:j.minY,maxY:j.maxY},globalOffset:{x:c.globalOffset.x,y:c.globalOffset.y}};var b=this.oldImage.globalOffset,L=Math.round(this.map.minPx.x),K=Math.round(this.map.maxPx.x),i=[{x:b.x,y:b.y}],A=K-L;i.push({x:b.x-A,y:b.y});i.push({x:b.x+A,y:b.y});for(var w,h,F,G,C,u,l,n,m,o,f,g,e,D,r,E,y=a.width,N=a.height,B=new Uint8Array(y*N),M=this.oldImage.data,v=this.oldImage.width,p=this.oldImage.bounds,s=a.width-1,t=a.height-1,J=i.length,x=0;x<J;x++){u=i[x];f=u.x-k.x;g=u.y-k.y;l=f+p.minX;n=g+p.minY;m=f+p.maxX;o=g+p.maxY;if(!(m<0||l>s||o<0||n>t)){e=l>0?l:0;r=n>0?n:0;D=m<s?m:s;E=o<t?o:t}else continue;C=D-e+1;w=r*y+e;F=(r-g)*v+(e-f);G=(E-g)*v+(e-f)+1;for(h=F;h<G;h+=v){B.set(M.subarray(h,h+C),w);w+=y}}this.oldImage.visibleData=B}a=MagicWand.floodFill(a,H,I,this.currentThreshold,this.oldImage.visibleData);if(!a)return false;if(this.blurRadius>0)a=MagicWand.gaussBlurOnlyBorder(a,this.blurRadius,this.oldImage.visibleData);a.globalOffset=k;a=this.concatMask(a,this.oldImage)}else{a=MagicWand.floodFill(a,H,I,this.currentThreshold);if(this.blurRadius>0)a=MagicWand.gaussBlurOnlyBorder(a,this.blurRadius);a.globalOffset=k}q.setImage(a);return true},CLASS_NAME:"OpenLayers.Control.MagicWand"});OpenLayers.Control.MagicWand.MaskHistory=OpenLayers.Class({history:null,current:-1,initialize:function(a){OpenLayers.Util.extend(this,a);this.history=[]},destroy:function(){this.history=null},clear:function(){this.history.length=0;this.current=-1},addMask:function(a){if(!a)return false;this.current++;this.history.length=this.current;this.history.push(a);return true},getCurrent:function(){return this.current>-1?this.history[this.current]:null},allowUndo:function(){return this.current>0},allowRedo:function(){return this.current<this.history.length-1},undo:function(){if(!this.allowUndo())return null;this.current--;return this.getCurrent()},redo:function(){if(!this.allowRedo())return null;this.current++;return this.getCurrent()}})
