<?php

@define('__POSTCALENDAR__', 'PostCalendar');
/**
 *  $Id$
 *
 *  PostCalendar::PostNuke Events Calendar Module
 *  Copyright (C) 2002  The PostCalendar Team
 *  http://postcalendar.tv
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  To read the license please read the docs/license.txt or visit
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

//=========================================================================
//  Load the API Functions and Language defines
//=========================================================================
pnModAPILoad(__POSTCALENDAR__, 'user');

// Added to improve security and standardization of input data to be used in
//  database insertion.

/**
 * view items
 * This is a standard function to provide an overview of all of the items
 * available from the module.
 */
function postcalendar_user_view()
{
    // get the vars that were passed in
    list($Date,
         $print,
         $viewtype,
         $jumpday,
         $jumpmonth,
         $jumpyear) = pnVarCleanFromInput(
             'Date',
             'print',
             'viewtype',
             'jumpday',
             'jumpmonth',
             'jumpyear'
         );

    $Date = postcalendar_getDate();

    if (!isset($viewtype)) {
        $viewtype = _SETTING_DEFAULT_VIEW;
    }

    // added to allow the view & providers to remain as the user last saw it -- JRM
    if ($_SESSION['viewtype']) {
        $viewtype = $_SESSION['viewtype'];
    }

    if (!empty($_SESSION['pc_username'])) {
        $pc_username = $_SESSION['pc_username'];
    }

    return postcalendar_user_display(array('viewtype' => $viewtype,'Date' => $Date,'print' => $print)) . postcalendar_footer();
}

/**
 * display item
 * This is a standard function to provide detailed information on a single item
 * available from the module.
 */
function postcalendar_user_display($args)
{
    list($eid, $viewtype, $tplview,
         $pc_username, $Date, $print, $category, $topic, $pc_facility) = pnVarCleanFromInput(
             'eid',
             'viewtype',
             'tplview',
             'pc_username',
             'Date',
             'print',
             'pc_category',
             'pc_topic',
             'pc_facility'
         );
    // added to allow the view & providers to remain as the user last saw it -- JRM
    if ($_SESSION['viewtype']) {
        $viewtype = $_SESSION['viewtype'];
    }

    extract($args);
    if (empty($Date) && empty($viewtype)) {
        return false;
    }

    $cacheid = md5(strtotime("now"));

    $out  = "\n\n<!-- START user_display -->\n\n";
    $out .= pnModAPIFunc('PostCalendar', 'user', 'buildView', array('Date' => $Date,
                                                                         'viewtype' => $viewtype,
                                                                         'cacheid' => $cacheid));
    $out .= "\n\n<!-- END user_display -->\n\n";

    // Return the output that has been generated by this function
    return $out;
}

/**
 * search events
 */
function postcalendar_user_search()
{
    $tpl = new pcSmarty();
    $k = isset($_REQUEST['pc_keywords']) ? pnVarCleanFromInput($_REQUEST['pc_keywords']) : '';
    $k_andor = pnVarCleanFromInput('pc_keywords_andor');
    $pc_category = pnVarCleanFromInput('pc_category');
    $pc_facility = pnVarCleanFromInput('pc_facility');
    $pc_topic = pnVarCleanFromInput('pc_topic');
    $submit = pnVarCleanFromInput('submit');
    $event_dur_hours = pnVarCleanFromInput('event_dur_hours');
    $event_dur_minutes = pnVarCleanFromInput('event_dur_minutes');
    $start = pnVarCleanFromInput('start');
    $end = pnVarCleanFromInput('end');

    // get list of categories for the user to choose from
    $categories = postcalendar_userapi_getCategories();
    $cat_options = '';
    foreach ($categories as $category) {
        $selected = "";
        if ($pc_category == $category['id']) {
            $selected = " SELECTED ";
        }

    //modified 8/09 by BM to allow translation if applicable
        $cat_options .= "<option value=\"" . attr($category['id']) . "\" $selected>" . text(xl_appt_category($category['name'])) . "</option>";
    }

    $tpl->assign_by_ref('CATEGORY_OPTIONS', $cat_options);

    $tpl->assign('event_dur_hours', $event_dur_hours);
    $tpl->assign('event_dur_minutes', $event_dur_minutes);

    // create default start and end dates for the search form
    if (isset($start) && $start != "") {
        $tpl->assign('DATE_START', $start);
    } else {
        $tpl->assign('DATE_START', date("m/d/Y"));
    }

    if (isset($end) && $end != "") {
        $tpl->assign('DATE_END', $end);
    } else {
        $tpl->assign('DATE_END', date("m/d/Y", strtotime("+7 Days", time())));
    }

    // then override the setting if we have a value from the submitted form
    $ProviderID = pnVarCleanFromInput("provider_id");
    if (is_numeric($ProviderID)) {
        $tpl->assign('ProviderID', $ProviderID);
    } elseif ($ProviderID == "_ALL_") {
        // do nothing
    } else {
        $tpl->assign('ProviderID', "");
    }

    $provinfo = getProviderInfo();
    $tpl->assign('providers', $provinfo);
    // build a list of provider-options for the select box on the input form -- JRM
    $provider_options = "<option value='_ALL_' ";
    if ($ProviderID == "_ALL_") {
        $provider_options .= " SELECTED ";
    }

    $provider_options .= ">" . xlt('All Providers') . "</option>";
    foreach ($provinfo as $provider) {
        $selected = "";
        // if we don't have a ProviderID chosen, pick the first one from the
        // pc_username Session variable
        if ($ProviderID == "") {
            // that variable stores the 'username' and not the numeric 'id'
            if ($_SESSION['pc_username'][0] == $provider['username']) {
                $selected = " SELECTED ";
            }
        } elseif ($ProviderID == $provider['id']) {
            $selected = " SELECTED ";
        }

        $provider_options .= "<option value=\"" . attr($provider['id']) . "\" " . $selected . ">";
        $provider_options .= text($provider['lname']) . ", " . text($provider['fname']) . "</option>";
    }

    $tpl->assign_by_ref('PROVIDER_OPTIONS', $provider_options);

    // build a list of facility options for the select box on the input form -- JRM
    $facilities = getFacilities();
    $fac_options = "<option value=''>" . xlt('All Facilities') . "</option>";
    foreach ($facilities as $facility) {
        $selected = "";
        if ($facility['id'] == $pc_facility) {
            $selected = " SELECTED ";
        }

        $fac_options .= "<option value=\"" . attr($facility['id']) . "\" " . $selected . ">";
        $fac_options .= text($facility['name']) . "</option>";
    }

    $tpl->assign_by_ref('FACILITY_OPTIONS', $fac_options);

    $PatientID = pnVarCleanFromInput("patient_id");
    // limit the number of results returned by getPatientPID
    // this helps to prevent the server from stalling on a request with
    // no PID and thousands of PIDs in the database -- JRM
    // the function getPatientPID($pid, $given, $orderby, $limit, $start) <-- defined in library/patient.inc
    $plistlimit = 500;
    if (is_numeric($PatientID)) {
        $tpl->assign('PatientList', getPatientPID(array('pid' => $PatientID, 'limit' => $plistlimit)));
    } else {
        $tpl->assign('PatientList', getPatientPID(array('limit' => $plistlimit)));
    }

    $event_endday = pnVarCleanFromInput("event_endday");
    $event_endmonth = pnVarCleanFromInput("event_endmonth");
    $event_endyear = pnVarCleanFromInput("event_endyear");

    $event_startday = pnVarCleanFromInput("event_startday");
    $event_startmonth = pnVarCleanFromInput("event_startmonth");
    $event_startyear = pnVarCleanFromInput("event_startyear");
    if ($event_startday > $event_endday) {
        $event_endday = $event_startday;
    }

    if ($event_startmonth > $event_endmonth) {
        $event_endmonth = $event_startmonth;
    }

    if ($event_startyear > $event_endyear) {
        $event_endyear = $event_startyear;
    }

    $tpl->assign('patient_id', $PatientID);
    $tpl->assign('provider_id', $ProviderID);
    $tpl->assign("event_category", pnVarCleanFromInput("event_category"));
    $tpl->assign("event_subject", pnVarCleanFromInput("event_subject"));
    $output = new pnHTML();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    if (_SETTING_USE_INT_DATES) {
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildDaySelect', array('pc_day' => $day,'selected' => $event_startday));
        $formdata = $output->FormSelectMultiple('event_startday', $sel_data);
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildMonthSelect', array('pc_month' => $month,'selected' => $event_startmonth));
        $formdata .= $output->FormSelectMultiple('event_startmonth', $sel_data);
    } else {
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildMonthSelect', array('pc_month' => ($month ?? null),'selected' => $event_startmonth));
        $formdata = $output->FormSelectMultiple('event_startmonth', $sel_data);
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildDaySelect', array('pc_day' => ($day ?? null),'selected' => $event_startday));
        $formdata .= $output->FormSelectMultiple('event_startday', $sel_data);
    }

    $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildYearSelect', array('pc_year' => ($year ?? null),'selected' => $event_startyear));
    $formdata .= $output->FormSelectMultiple('event_startyear', $sel_data);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $tpl->assign('SelectDateTimeStart', $formdata);
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    if (_SETTING_USE_INT_DATES) {
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildDaySelect', array('pc_day' => $day,'selected' => $event_endday));
        $formdata = $output->FormSelectMultiple('event_endday', $sel_data);
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildMonthSelect', array('pc_month' => $month,'selected' => $event_endmonth));
        $formdata .= $output->FormSelectMultiple('event_endmonth', $sel_data);
    } else {
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildMonthSelect', array('pc_month' => ($month ?? null),'selected' => $event_endmonth));
        $formdata = $output->FormSelectMultiple('event_endmonth', $sel_data);
        $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildDaySelect', array('pc_day' => ($day ?? null),'selected' => $event_endday ));
        $formdata .= $output->FormSelectMultiple('event_endday', $sel_data);
    }

    $sel_data = pnModAPIFunc(__POSTCALENDAR__, 'user', 'buildYearSelect', array('pc_year' => ($year ?? null),'selected' => $event_endyear));
    $formdata .= $output->FormSelectMultiple('event_endyear', $sel_data);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $tpl->assign('SelectDateTimeEnd', $formdata);
    $output = null;
    if (_SETTING_DISPLAY_TOPICS) {
        $topics = postcalendar_userapi_getTopics();
        $top_options = '';
        foreach ($topics as $topic) {
            $top_options .= "<option value=\"" . attr($topic['id']) . "\">" . text($topic['text']) . "</option>";
        }

        $tpl->assign_by_ref('TOPIC_OPTIONS', $top_options);
    }

    //=================================================================
    //  Find out what Template we're using
    //=================================================================
    $template_name = _SETTING_TEMPLATE;
    if (!isset($template_name)) {
        $template_name = 'default';
    }

    //=================================================================
    //  Output the search form
    //=================================================================
        $tpl->assign('FORM_ACTION', pnModURL(__POSTCALENDAR__, 'user', 'search'));
    //=================================================================
    //  Perform the search if we have data
    //=================================================================
    if (!empty($submit) && strtolower($submit) == "find first") {
        // not sure how we get here...
        $searchargs = array();
        $searchargs['start'] = pnVarCleanFromInput("event_startmonth") . "/" . pnVarCleanFromInput("event_startday") . "/" . pnVarCleanFromInput("event_startyear");
        $searchargs['end'] = pnVarCleanFromInput("event_endmonth") . "/" . pnVarCleanFromInput("event_endday") . "/" . pnVarCleanFromInput("event_endyear");
        $searchargs['provider_id'] = pnVarCleanFromInput("provider_id");
        $searchargs['faFlag'] = true;
        //print_r($searchargs);
        //echo "<br />";
        //set defaults to current week if empty
        if ($searchargs['start'] == "//") {
            $searchargs['start'] = date("m/d/Y");
        }

        if ($searchargs['end'] == "//") {
            $searchargs['end'] = date("m/d/Y", strtotime("+7 Days", strtotime($searchargs['start'])));
        }

        //print_r($searchargs);
        $eventsByDate =& postcalendar_userapi_pcGetEvents($searchargs);
        //print_r($eventsByDate);
        $found = findFirstAvailable($eventsByDate);
        $tpl->assign('available_times', $found);
        //print_r($_POST);

        $tpl->assign('SEARCH_PERFORMED', true);
        $tpl->assign('A_EVENTS', $eventsByDate);
    }

    if (!empty($submit) && strtolower($submit) == "listapps") {
        // not sure how we get here...
        $searchargs = array();
        $searchargs['start'] = date("m/d/Y");
        $searchargs['end'] = date("m/d/Y", strtotime("+1 year", strtotime($searchargs['start'])));
        $searchargs['patient_id'] = pnVarCleanFromInput("patient_id");
        $searchargs['listappsFlag'] = true;

        $sqlKeywords .= "(a.pc_pid = '" . add_escape_custom(pnVarCleanFromInput("patient_id")) . "' )";

        $searchargs['s_keywords'] = $sqlKeywords;
        //print_r($searchargs);
        $eventsByDate =& postcalendar_userapi_pcGetEvents($searchargs);
        //print_r($eventsByDate);
        $tpl->assign('appointments', $eventsByDate);
        //print_r($_POST);

        $tpl->assign('SEARCH_PERFORMED', true);
        $tpl->assign('A_EVENTS', $eventsByDate);
    } elseif (!empty($submit)) {
        // we get here by searching via the PostCalendar search
        $sqlKeywords = '';
        $keywords = explode(' ', $k);
        // build our search query
        foreach ($keywords as $word) {
            if (!empty($sqlKeywords)) {
                $sqlKeywords .= " $k_andor ";
            }

            $sqlKeywords .= '(';
            $sqlKeywords .= "pd.lname LIKE '%" . add_escape_custom($word) . "%' OR ";
            $sqlKeywords .= "pd.fname LIKE '%" . add_escape_custom($word) . "%' OR ";
            $sqlKeywords .= "u.lname LIKE '%" . add_escape_custom($word) . "%' OR ";
            $sqlKeywords .= "u.fname LIKE '%" . add_escape_custom($word) . "%' OR ";
            $sqlKeywords .= "a.pc_title LIKE '%" . add_escape_custom($word) . "%' OR ";
            $sqlKeywords .= "a.pc_hometext LIKE '%" . add_escape_custom($word) . "%' OR ";
            $sqlKeywords .= "a.pc_location LIKE '%" . add_escape_custom($word) . "%'";
            $sqlKeywords .= ') ';
        }


        if (!empty($pc_category)) {
            $s_category = "a.pc_catid = '" . add_escape_custom($pc_category) . "'";
        }

        if (!empty($pc_topic)) {
            $s_topic = "a.pc_topic = '" . add_escape_custom($pc_topic) . "'";
        }

        $searchargs = array();
        if (!empty($sqlKeywords)) {
            $searchargs['s_keywords'] = $sqlKeywords;
        }

        if (!empty($s_category)) {
            $searchargs['s_category'] = $s_category;
        }

        if (!empty($s_topic)) {
            $searchargs['s_topic'] = $s_topic;
        }

        // some new search parameters introduced in the ajax_search form...  JRM March 2008

        // the ajax_search form has form parameters for 'start' and 'end' already built in
        // so use them if available
        $tmpDate = pnVarCleanFromInput("start");
        if (isset($tmpDate) && $tmpDate != "") {
            $searchargs['start'] = pnVarCleanFromInput("start");
        } else {
            $searchargs['start'] = "//";
        }

        $tmpDate = pnVarCleanFromInput("end");
        if (isset($tmpDate) && $tmpDate != "") {
            $searchargs['end'] = pnVarCleanFromInput("end");
        } else {
            $searchargs['end'] = "//";
        }

        // we can limit our search by provider -- JRM March 2008
        if (isset($ProviderID) && $ProviderID != "") { // && $ProviderID != "_ALL_") {
            $searchargs['provider_id'] = array();
            array_push($searchargs['provider_id'], $ProviderID);
        }

        $eventsByDate =& postcalendar_userapi_pcGetEvents($searchargs);

        // we can limit our search by facility -- JRM March 2008
        if (isset($pc_facility) && $pc_facility != "") {
            $searchargs['pc_facility'] = $pc_facility;
        }

        //print_r($eventsByDate);
        $tpl->assign('SEARCH_PERFORMED', true);
        $tpl->assign('A_EVENTS', $eventsByDate);
    }

    $tpl->caching = false;
    $tpl->assign('STYLE', $GLOBALS['style']);
    $pageSetup =& pnModAPIFunc(__POSTCALENDAR__, 'user', 'pageSetup');
    $return = $pageSetup . $tpl->fetch($template_name . '/user/ajax_search.html');
    return $return;
}
