<?php

/**
 * Forms generated from formsWiz
 * script to save Review of Systems Checks Form
 *
 * @package   OpenEMR
 * @link      http://www.open-emr.org
 * @author    Roberto Vasquez <robertogagliotta@gmail.com>
 * @author    Brady Miller <brady.g.miller@gmail.com>
 * @copyright Copyright (c) 2015 Roberto Vasquez <robertogagliotta@gmail.com>
 * @copyright Copyright (c) 2019 Brady Miller <brady.g.miller@gmail.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 */

require_once(__DIR__ . "/../../globals.php");
require_once("$srcdir/api.inc");
require_once("$srcdir/forms.inc");

use OpenEMR\Common\Csrf\CsrfUtils;

if (!CsrfUtils::verifyCsrfToken($_POST["csrf_token_form"])) {
    CsrfUtils::csrfNotVerified();
}

if ($encounter == "") {
    $encounter = date("Ymd");
}

if ($_GET["mode"] == "new") {
    $newid = formSubmit("form_reviewofs", $_POST, ($_GET["id"] ?? ''), $userauthorized);
    addForm($encounter, "Review of Systems Checks", $newid, "reviewofs", $pid, $userauthorized);
} elseif ($_GET["mode"] == "update") {
    sqlStatement(
        "UPDATE form_reviewofs set pid = ?,
            groupname=?,
            user=?,
            authorized=?,
            activity=1,
            date = NOW(),
            fever=?,
            chills=?,
            night_sweats=?,
            weight_loss=?,
            poor_appetite=?,
            insomnia=?,
            fatigued=?,
            depressed=?,
            hyperactive=?,
            exposure_to_foreign_countries=?,
            cataracts=?,
            cataract_surgery=?,
            glaucoma=?,
            double_vision=?,
            blurred_vision=?,
            poor_hearing=?,
            headaches=?,
            ringing_in_ears=?,
            bloody_nose=?,
            sinusitis=?,
            sinus_surgery=?,
            dry_mouth=?,
            strep_throat=?,
            tonsillectomy=?,
            swollen_lymph_nodes=?,
            throat_cancer=?,
            throat_cancer_surgery=?,
            heart_attack=?,
            irregular_heart_beat=?,
            chest_pains=?,
            shortness_of_breath=?,
            high_blood_pressure=?,
            heart_failure=?,
            poor_circulation=?,
            vascular_surgery=?,
            cardiac_catheterization=?,
            coronary_artery_bypass=?,
            heart_transplant=?,
            stress_test=?,
            emphysema=?,
            chronic_bronchitis=?,
            interstitial_lung_disease=?,
            shortness_of_breath_2=?,
            lung_cancer=?,
            lung_cancer_surgery=?,
            pheumothorax=?,
            stomach_pains=?,
            peptic_ulcer_disease=?,
            gastritis=?,
            endoscopy=?,
            polyps=?,
            colonoscopy=?,
            colon_cancer=?,
            colon_cancer_surgery=?,
            ulcerative_colitis=?,
            crohns_disease=?,
            appendectomy=?,
            divirticulitis=?,
            divirticulitis_surgery=?,
            gall_stones=?,
            cholecystectomy=?,
            hepatitis=?,
            cirrhosis_of_the_liver=?,
            splenectomy=?,
            kidney_failure=?,
            kidney_stones=?,
            kidney_cancer=?,
            kidney_infections=?,
            bladder_infections=?,
            bladder_cancer=?,
            prostate_problems=?,
            prostate_cancer=?,
            kidney_transplant=?,
            sexually_transmitted_disease=?,
            burning_with_urination=?,
            discharge_from_urethra=?,
            rashes=?,
            infections=?,
            ulcerations=?,
            pemphigus=?,
            herpes=?,
            osetoarthritis=?,
            rheumotoid_arthritis=?,
            lupus=?,
            ankylosing_sondlilitis=?,
            swollen_joints=?,
            stiff_joints=?,
            broken_bones=?,
            neck_problems=?,
            back_problems=?,
            back_surgery=?,
            scoliosis=?,
            herniated_disc=?,
            shoulder_problems=?,
            elbow_problems=?,
            wrist_problems=?,
            hand_problems=?,
            hip_problems=?,
            knee_problems=?,
            ankle_problems=?,
            foot_problems=?,
            insulin_dependent_diabetes=?,
            noninsulin_dependent_diabetes=?,
            hypothyroidism=?,
            hyperthyroidism=?,
            cushing_syndrom=?,
            addison_syndrom=?,
            additional_notes=? WHERE id=?",
        [
            $_SESSION["pid"],
            $_SESSION["authProvider"],
            $_SESSION["authUser"],
            $userauthorized,
            ($_POST["fever"] ?? null),
            ($_POST["chills"] ?? null),
            ($_POST["night_sweats"] ?? null),
            ($_POST["weight_loss"] ?? null),
            ($_POST["poor_appetite"] ?? null),
            ($_POST["insomnia"] ?? null),
            ($_POST["fatigued"] ?? null),
            ($_POST["depressed"] ?? null),
            ($_POST["hyperactive"] ?? null),
            ($_POST["exposure_to_foreign_countries"] ?? null),
            ($_POST["cataracts"] ?? null),
            ($_POST["cataract_surgery"] ?? null),
            ($_POST["glaucoma"] ?? null),
            ($_POST["double_vision"] ?? null),
            ($_POST["blurred_vision"] ?? null),
            ($_POST["poor_hearing"] ?? null),
            ($_POST["headaches"] ?? null),
            ($_POST["ringing_in_ears"] ?? null),
            ($_POST["bloody_nose"] ?? null),
            ($_POST["sinusitis"] ?? null),
            ($_POST["sinus_surgery"] ?? null),
            ($_POST["dry_mouth"] ?? null),
            ($_POST["strep_throat"] ?? null),
            ($_POST["tonsillectomy"] ?? null),
            ($_POST["swollen_lymph_nodes"] ?? null),
            ($_POST["throat_cancer"] ?? null),
            ($_POST["throat_cancer_surgery"] ?? null),
            ($_POST["heart_attack"] ?? null),
            ($_POST["irregular_heart_beat"] ?? null),
            ($_POST["chest_pains"] ?? null),
            ($_POST["shortness_of_breath"] ?? null),
            ($_POST["high_blood_pressure"] ?? null),
            ($_POST["heart_failure"] ?? null),
            ($_POST["poor_circulation"] ?? null),
            ($_POST["vascular_surgery"] ?? null),
            ($_POST["cardiac_catheterization"] ?? null),
            ($_POST["coronary_artery_bypass"] ?? null),
            ($_POST["heart_transplant"] ?? null),
            ($_POST["stress_test"] ?? null),
            ($_POST["emphysema"] ?? null),
            ($_POST["chronic_bronchitis"] ?? null),
            ($_POST["interstitial_lung_disease"] ?? null),
            ($_POST["shortness_of_breath_2"] ?? null),
            ($_POST["lung_cancer"] ?? null),
            ($_POST["lung_cancer_surgery"] ?? null),
            ($_POST["pheumothorax"] ?? null),
            ($_POST["stomach_pains"] ?? null),
            ($_POST["peptic_ulcer_disease"] ?? null),
            ($_POST["gastritis"] ?? null),
            ($_POST["endoscopy"] ?? null),
            ($_POST["polyps"] ?? null),
            ($_POST["colonoscopy"] ?? null),
            ($_POST["colon_cancer"] ?? null),
            ($_POST["colon_cancer_surgery"] ?? null),
            ($_POST["ulcerative_colitis"] ?? null),
            ($_POST["crohns_disease"] ?? null),
            ($_POST["appendectomy"] ?? null),
            ($_POST["divirticulitis"] ?? null),
            ($_POST["divirticulitis_surgery"] ?? null),
            ($_POST["gall_stones"] ?? null),
            ($_POST["cholecystectomy"] ?? null),
            ($_POST["hepatitis"] ?? null),
            ($_POST["cirrhosis_of_the_liver"] ?? null),
            ($_POST["splenectomy"] ?? null),
            ($_POST["kidney_failure"] ?? null),
            ($_POST["kidney_stones"] ?? null),
            ($_POST["kidney_cancer"] ?? null),
            ($_POST["kidney_infections"] ?? null),
            ($_POST["bladder_infections"] ?? null),
            ($_POST["bladder_cancer"] ?? null),
            ($_POST["prostate_problems"] ?? null),
            ($_POST["prostate_cancer"] ?? null),
            ($_POST["kidney_transplant"] ?? null),
            ($_POST["sexually_transmitted_disease"] ?? null),
            ($_POST["burning_with_urination"] ?? null),
            ($_POST["discharge_from_urethra"] ?? null),
            ($_POST["rashes"] ?? null),
            ($_POST["infections"] ?? null),
            ($_POST["ulcerations"] ?? null),
            ($_POST["pemphigus"] ?? null),
            ($_POST["herpes"] ?? null),
            ($_POST["osetoarthritis"] ?? null),
            ($_POST["rheumotoid_arthritis"] ?? null),
            ($_POST["lupus"] ?? null),
            ($_POST["ankylosing_sondlilitis"] ?? null),
            ($_POST["swollen_joints"] ?? null),
            ($_POST["stiff_joints"] ?? null),
            ($_POST["broken_bones"] ?? null),
            ($_POST["neck_problems"] ?? null),
            ($_POST["back_problems"] ?? null),
            ($_POST["back_surgery"] ?? null),
            ($_POST["scoliosis"] ?? null),
            ($_POST["herniated_disc"] ?? null),
            ($_POST["shoulder_problems"] ?? null),
            ($_POST["elbow_problems"] ?? null),
            ($_POST["wrist_problems"] ?? null),
            ($_POST["hand_problems"] ?? null),
            ($_POST["hip_problems"] ?? null),
            ($_POST["knee_problems"] ?? null),
            ($_POST["ankle_problems"] ?? null),
            ($_POST["foot_problems"] ?? null),
            ($_POST["insulin_dependent_diabetes"] ?? null),
            ($_POST["noninsulin_dependent_diabetes"] ?? null),
            ($_POST["hypothyroidism"] ?? null),
            ($_POST["hyperthyroidism"] ?? null),
            ($_POST["cushing_syndrom"] ?? null),
            ($_POST["addison_syndrom"] ?? null),
            ($_POST["additional_notes"] ?? null),
            $_GET["id"]
        ]
    );
}

formHeader("Redirecting....");
formJump();
formFooter();
